use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- Script 6600_66442
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_CreateSurveyStatisticsUpdateJob]'')  AND type in (N''P'', N''	PC''))
   DROP PROCEDURE [dbo].[VX_CreateSurveyStatisticsUpdateJob]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_CreateSurveyStatisticsUpdateJob] AS
BEGIN
DECLARE @dbName VARCHAR(255)
SELECT @dbName=DB_NAME()
DECLARE @jobId BINARY(16)
DECLARE @jobName NVARCHAR(255)
SET @jobName = ''ASPState_Job_UpdateSurveyStatistics_'' + @dbName

/****** Object:  Job [ASPState_Job_UpdateSurveyStatistics]     ******/
IF  EXISTS (SELECT job_id FROM msdb.dbo.sysjobs_view WHERE name = @jobName)
EXEC msdb.dbo.sp_delete_job @job_name=@jobName, @delete_unused_schedule=1

/****** Object:  Job [ASPState_Job_UpdateSurveyStatistics]    ******/
BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
/****** Object:  JobCategory [VSE_CleaningJobs]     ******/
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=''VX_StatisticJobs'' AND category_class=1)
BEGIN
 EXEC @ReturnCode = msdb.dbo.sp_add_category @class=''JOB'', @type=''LOCAL'', @name=''VX_StatisticJobs''
 IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
 BEGIN
  IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
  RAISERROR(''Failed calling sp_add_category with VX_StatisticJobs'', 11, 1)
  RETURN
 END
END

EXEC @ReturnCode =  msdb.dbo.sp_add_job @job_name=@jobName, 
  @enabled=1, 
  @notify_level_eventlog=2, 
  @notify_level_email=0, 
  @notify_level_netsend=0, 
  @notify_level_page=0, 
  @delete_level=0, 
  @description=''Updates statistics for all projects in ProjectStatistics having NeedsUpdate=1.'', 
  @category_name=''VX_StatisticJobs'', 
  @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
BEGIN
 IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
 RAISERROR(''Failed calling sp_add_job with ASPState_Job_UpdateSurveyStatistics'', 11, 1)
 RETURN
END

DECLARE @stepName NVARCHAR(255)
SET @stepName = @jobName

/****** Object:  Step [ASPState_JobStep_DeleteExpiredSessions]   ******/
 EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=@stepName, 
  @step_id=1, 
  @cmdexec_success_code=0, 
  @on_success_action=1, 
  @on_success_step_id=0, 
  @on_fail_action=2, 
  @on_fail_step_id=0, 
  @retry_attempts=0, 
  @retry_interval=1, 
  @os_run_priority=0, @subsystem=''TSQL'', 
  @command=''EXECUTE [dbo].[VX_UpdateStatisticsForAllDirtySurveys]'', 
  @database_name=@dbName, 
  @flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
BEGIN
 IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
 RAISERROR(''Failed calling sp_add_jobstep with ASPState_Job_UpdateSurveyStatistics'', 11, 1)
 RETURN
 END
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0)
BEGIN
 IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
 RAISERROR(''Failed calling sp_update_job'', 11, 1)
 RETURN
END
DECLARE @scheduleName NVARCHAR(255)
SET @scheduleName = ''ASPState_JobSchedule_UpdateSurveyStatistics_'' + @dbName
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=@scheduleName, 
  @enabled=1, 
  @freq_type=4, 
  @freq_interval=1, 
  @freq_subday_type=2, 
  @freq_subday_interval=10, 
  @freq_relative_interval=0, 
  @freq_recurrence_factor=0, 
  @active_start_date=20001016, 
  @active_end_date=99991231, 
  @active_start_time=0, 
  @active_end_time=235959
IF (@@ERROR <> 0 OR @ReturnCode <> 0)
BEGIN
 IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
 RAISERROR(''Failed calling sp_add_jobschedule with ASPState_JobSchedule_UpdateSurveyStatistics'', 11, 1)
 RETURN
END
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = ''(local)''
IF (@@ERROR <> 0 OR @ReturnCode <> 0) 
BEGIN
 IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
 RAISERROR(''Failed calling sp_add_jobserver'', 11, 1)
 RETURN
 END
COMMIT TRANSACTION
END
'

declare @ClientPayload03 nvarchar(max) = N'
EXEC [dbo].[VX_CreateSurveyStatisticsUpdateJob]
'

declare @ClientPayload04 nvarchar(max) = N'
-- Script 6600_66446
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[VX_listsp_Generic]'')  AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[VX_listsp_Generic]
'

declare @ClientPayload05 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_listsp_Generic]
 @userId int,     -- who is this query for ?
 @systemQuery nvarchar(MAX),
 @nvcFilter nvarchar(MAX),
 @nvcSortOrder  nvarchar(MAX), -- must be provided - cannot be null except when getting count
 @iStartIndex int,    -- pagination stard index
 @iEndIndex int,     -- pagination end endex
 @getCountOnly bit,
 @useSecurity bit,
 @accessKeyName nvarchar(256), -- Name of the column containing the id of the object
 @vcAdditionalSecuriyFilter VARCHAR(MAX) = '' AND ( (ISNULL(AllowedPermissions,0) & 1)=1 AND (ISNULL(DeniedPermissions,0) & 1)=0 AND ObjectTypeId IN (2,3))''
AS
BEGIN
 SET NOCOUNT ON;

  -- local variables
 DECLARE @hasRowNum bit
 DECLARE @query nvarchar(MAX)
 DECLARE @pageQuery nvarchar(MAX)
 
 DECLARE @securityJoinClause nvarchar(MAX)
 DECLARE @securityColumns nvarchar(256)
 SET @securityJoinClause='''';
 SET @securityColumns='''';
 IF @useSecurity=1 
 BEGIN
  -- if user not an administrator (administrators are part of system groups
  IF (SELECT dbo.VSM_IsUserAdministrator(@userId)) = 0
  BEGIN
   SET @securityColumns = '',objectPermissions.AllowedPermissions & ~objectPermissions.DeniedPermissions AS AllowedPermissions, objectPermissions.DeniedPermissions AS DeniedPermissions''
   SET @securityJoinClause=''JOIN (SELECT * FROM #permissions) objectPermissions ON objectPermissions.ObjectId=_sqry_.[''+@accessKeyName+'']''
   IF( @vcAdditionalSecuriyFilter IS NOT NULL )
   BEGIN
    SET @securityJoinClause = @securityJoinClause + @vcAdditionalSecuriyFilter
   END
  END
 END
 
 IF @securityColumns = ''''
 BEGIN
  -- if we ignore the security, we still need to return the AllowedPermissions column for the UI to work properly
  SET @securityColumns = '',convert(int,0xFFFFFFFF) AS AllowedPermissions''
 END

 -- Pagination
 SET @hasRowNum=1
 IF (@iStartIndex > 0 AND @iEndIndex > 0)
  SET @pageQuery='' WHERE src.[RowNum] BETWEEN @iStartIndex AND @iEndIndex''
 ELSE IF (@iStartIndex > 0)
  SET @pageQuery='' WHERE src.[RowNum] >= @iStartIndex''
 ELSE IF (@iEndIndex > 0)
  SET @pageQuery='' WHERE src.[RowNum] <= @iEndIndex''
 ELSE
  SET @hasRowNum=0

 SET @query = '''';

 IF (@securityJoinClause <> '''')
  SET @query = @query + '' SELECT * INTO #permissions FROM VSM_fn_GetUserPermissions(@userId) '';

 -- Is it for count ?
 IF (@getCountOnly <> 0) 
 BEGIN
  SET @hasRowNum=0
  SET @query = @query + ''SELECT COUNT(1)'' ;
 END 
 ELSE 
 BEGIN
  -- Returns a table
  -- select returned columns 

  SET @query = @query + ''SELECT *'' ;
  IF (@nvcSortOrder IS NULL OR LEN(@nvcSortOrder)=0)
   SET @hasRowNum=0
 END


 -- Row numbering
 IF (@hasRowNum <> 0)
  SET @query=@query + '' FROM (SELECT ROW_NUMBER() OVER (ORDER BY '' +
        @nvcSortOrder + '') AS ''''RowNum'''', * FROM''
 ELSE
  SET @query=@query + '' FROM (SELECT TOP 2147483647 * FROM''

 -- Master query
 SET @query=@query + '' (SELECT _sqry_.*''+@securityColumns+'' FROM ('' + @systemQuery + '') as _sqry_ '' + @securityJoinClause + '') AS mfqry''

 -- Use Filter ?
 IF (@nvcFilter IS NOT NULL AND LEN(@nvcFilter)>0)
  SET @query=@query + '' WHERE ('' + @nvcFilter + '')''
  
 -- Set inner sort order for count (optimize performance)
 IF (@nvcSortOrder IS NOT NULL AND LEN(@nvcSortOrder) > 0 AND @getCountOnly <> 0)
	SET @query=@query + '' ORDER BY '' + @nvcSortOrder+ '' ) AS src'' ;
 ELSE
	 SET @query=@query + '') AS src'' ;

 -- Pagination
 IF @hasRowNum <> 0
  SET @query=@query + @pageQuery
 ELSE IF (@iStartIndex < 0 AND @iEndIndex < 0) BEGIN
  -- No pagination but we may still have to use the sort order
  IF (@nvcSortOrder IS NOT NULL AND LEN(@nvcSortOrder) > 0 AND @getCountOnly = 0)
   SET @query=@query + '' ORDER BY '' + @nvcSortOrder
 END

 SET @query = ''SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;'' + @query;

 IF (@securityJoinClause <> '''')
  SET @query = @query + '' DROP TABLE #permissions'';

 EXEC sp_executesql @query, N''@userId int, @iStartIndex int, @iEndIndex int'', @userId, @iStartIndex, @iEndIndex
END
'

declare @ClientPayload06 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_HasActiveSurveys]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[VX_sp_HasActiveSurveys]
'

declare @ClientPayload07 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_HasActiveSurveys]
    @folderId INT
AS
BEGIN
    WITH x ([Id], [ParentFolderId])
	AS (
	    SELECT [Id], [ParentFolderId]
	    FROM [dbo].[SurveyFolder] WITH(NOLOCK)
	    WHERE [Id] = @folderId
	    UNION ALL
	    SELECT childFolder.[Id], childFolder.[ParentFolderId]
	    FROM [dbo].[SurveyFolder] childFolder WITH(NOLOCK)
		INNER JOIN x AS parentFolder ON childFolder.[ParentFolderId] = parentFolder.[Id]
	)
	SELECT CASE WHEN EXISTS (
		SELECT 1
		FROM [dbo].[Survey] survey WITH(NOLOCK)
		INNER JOIN x AS surveyFolder WITH(NOLOCK) ON survey.[SurveyFolderId] = surveyFolder.[Id]
		WHERE survey.[Status] = 3
	) THEN 1 ELSE 0 END;
END
'

declare @ClientPayload08 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_GetAllowedSurveys]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[VX_sp_GetAllowedSurveys]
'

declare @ClientPayload09 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_GetAllowedSurveys]
    @userId INT
AS
BEGIN
    SELECT [ObjectId]
	FROM [dbo].[VSM_fn_GetUserPermissions](@userId) objectPermissions
    WHERE objectPermissions.[ObjectTypeId] = 2
		AND (ISNULL(objectPermissions.[AllowedPermissions], 0) & 1) = 1
		AND (ISNULL(objectPermissions.[DeniedPermissions], 0) & 1) = 0;
END
'

declare @ClientPayload10 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[VX_sp_HasAllowedActiveSurveys]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[VX_sp_HasAllowedActiveSurveys]
'

declare @ClientPayload11 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[VX_sp_HasAllowedActiveSurveys]
    @folderId INT,
    @allowedSurveys [dbo].[IdList] READONLY
AS
BEGIN
    WITH x ([Id], [ParentFolderId])
	AS (
	    SELECT [Id], [ParentFolderId]
	    FROM [dbo].[SurveyFolder] WITH(NOLOCK)
	    WHERE [Id] = @folderId
	    UNION ALL
	    SELECT childFolder.[Id], childFolder.[ParentFolderId]
	    FROM [dbo].[SurveyFolder] childFolder WITH(NOLOCK)
		INNER JOIN x AS parentFolder ON childFolder.[ParentFolderId] = parentFolder.[Id]
	)
    SELECT CASE WHEN EXISTS (
        SELECT 1
        FROM [dbo].[Survey] survey WITH(NOLOCK)
        INNER JOIN x AS surveyFolder WITH(NOLOCK) ON survey.[SurveyFolderId] = surveyFolder.[Id]
		INNER JOIN @allowedSurveys allowedSurveys ON survey.[Id] = allowedSurveys.[Id]
        WHERE survey.[Status] = 3
    ) THEN 1 ELSE 0 END;
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload04, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload05, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload06, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload07, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload08, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload09, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload10, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		select @SQL = replace(replace(@ClientPayload11, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone